/*
 * Copyright (C) 2014, Samsung Electronics, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * aint with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef TextureMapperHoleLayer_h
#define TextureMapperHoleLayer_h

#if USE(TEXTURE_MAPPER)

#include "TextureMapperPlatformLayer.h"

namespace WebCore {

class TextureMapperHoleLayer : public TextureMapperPlatformLayerRefCounted {
    WTF_MAKE_NONCOPYABLE(TextureMapperHoleLayer); WTF_MAKE_FAST_ALLOCATED;
public:
    static PassRefPtr<TextureMapperHoleLayer> create() { return adoptRef(new TextureMapperHoleLayer); }
    virtual ~TextureMapperHoleLayer() { }
    virtual void paintToTextureMapper(TextureMapper*, const FloatRect& target, const TransformationMatrix& = TransformationMatrix(), float opacity = 1.0) OVERRIDE;
    virtual bool isHole() const OVERRIDE { return true; }

    // Ensure to have a valid layer.
#if USE(GRAPHICS_SURFACE)
    virtual GraphicsSurfaceToken graphicsSurfaceToken() const OVERRIDE { return GraphicsSurfaceToken(1, 1); }
#endif

private:
    TextureMapperHoleLayer()
        : TextureMapperPlatformLayerRefCounted()
        { }
};

} // namespace WebCore

#endif

#endif // TextureMapperHoleLayer_h
