/*
 * Copyright (C) 2014, Samsung Electronics, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * aint with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"

#if USE(TEXTURE_MAPPER)
#include "TextureMapperHoleLayer.h"

#include "ColorSpace.h"
#include "GraphicsContext3D.h"
#include "TextureMapper.h"
#include "TextureMapperGL.h"
#include <wtf/Functional.h>
#include <wtf/MainThread.h>

namespace WebCore {

void TextureMapperHoleLayer::paintToTextureMapper(TextureMapper* textureMapper, const FloatRect& target, const TransformationMatrix& matrix, float)
{
    if (!static_cast<TextureMapperGL*>(textureMapper)->isVisibleInScissorBox(target, matrix))
        return;

    TextureMapperGL* texmapGL = static_cast<TextureMapperGL*>(textureMapper);
    texmapGL->beginClip(matrix, target);
    texmapGL->graphicsContext3D()->clearColor(0.0f, 0.0f, 0.0f, 0.0f);
    texmapGL->graphicsContext3D()->clear(GraphicsContext3D::COLOR_BUFFER_BIT);
    texmapGL->endClip();
}

}

#endif
