/*
 *  Copyright (C) 2010 Igalia S.L
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */


#ifndef GStreamerGWorld_h
#define GStreamerGWorld_h
#if ENABLE(VIDEO) && USE(GSTREAMER)

#include <wtf/RefCounted.h>
#include <wtf/RefPtr.h>
#include <wtf/gobject/GOwnPtr.h>

#include "PlatformVideoWindow.h"

#include <glib.h>
#include <gst/gst.h>
#include <wayland-client.h>
#include <wayland/freebox.h>

namespace WebCore {

class MediaPlayerPrivateGStreamer;

GstBusSyncReply gstGWorldSyncMessageCallback(GstBus* bus, GstMessage* message, gpointer data);

void registry_handle_global(void *data, struct wl_registry *registry,
                            uint32_t id, const char *interface,
                            uint32_t version);

class GStreamerGWorld : public RefCounted<GStreamerGWorld> {
    friend GstBusSyncReply gstGWorldSyncMessageCallback(GstBus* bus, GstMessage* message, gpointer data);
    friend void registry_handle_global(void *data,
                                       struct wl_registry *registry,
                                       uint32_t id, const char *interface,
                                       uint32_t version);

public:
    static PassRefPtr<GStreamerGWorld> createGWorld(GstElement*);
    ~GStreamerGWorld();

    GstElement* pipeline() const { return m_pipeline; }

    // Returns the full-screen window created
    bool enterFullscreen();
    void exitFullscreen();

    bool isFullscreen() const { return false; }

    uint32_t overlayID() const;
    bool hasOverlay() const;

    void expose();

    void setWindowOverlay(GstMessage* message);
    PlatformVideoWindow* platformVideoWindow() const { return m_videoWindow.get(); }

private:
    GStreamerGWorld(GstElement*);
    GstElement* m_pipeline;
    RefPtr<PlatformVideoWindow> m_videoWindow;

    struct wl_compositor *wl_compositor;
    struct wl_subcompositor *wl_subcompositor;
    struct wl_surface *wl_surface;
    struct fbx_foreign_surface_manager *fbx_fsm;
    struct fbx_foreign_surface *fbx_foreign_surface;

public:
    uint32_t m_overlay_id;
};

}
#endif // ENABLE(VIDEO) && USE(GSTREAMER)
#endif
