// -*- c++ -*-
#ifndef QWAYLANDFBXSERVICES_H
#define QWAYLANDFBXSERVICES_H

#include <QtCore/QObject>

#include <qpa/qplatformservices.h>

class QFbxAppClient;
class QUrl;

class Q_GUI_EXPORT QFbxServices
    : public QPlatformServices
{
public:
    QFbxServices(QFbxAppClient *client);
    virtual ~QFbxServices();

    bool openUrl(const QUrl &url) override;
    bool openDocument(const QUrl &url) override;

    QByteArray desktopEnvironment() const override;

private:
    Q_DISABLE_COPY(QFbxServices);
    QFbxAppClient *m_client;
};

#endif
