#include <QtCore/QUrl>
#include <qpa/qplatformnativeinterface.h>
#include <QJsonObject>

#include <QFbxAppClient.hh>
#include "qfbxservices.h"

QFbxServices::QFbxServices(QFbxAppClient *client)
    : QPlatformServices(), m_client(client)
{
}

QFbxServices::~QFbxServices()
{
}

bool QFbxServices::openUrl(const QUrl &url)
{
    QJsonObject obj;
    obj["url"] = url.toString();
    obj["media_type"] = "";
    m_client->shellRequest((uint32_t)-1, "url_open", obj);

    return true;
}

bool QFbxServices::openDocument(const QUrl &url)
{
    QJsonObject obj;
    obj["url"] = url.toString();
    obj["media_type"] = "";
    m_client->shellRequest((uint32_t)-1, "url_open", obj);

    return true;
}

QByteArray QFbxServices::desktopEnvironment() const
{
    return QByteArray("FREEBOX");
}
