#ifndef QWAYLANDFBXTEXT_H
#define QWAYLANDFBXTEXT_H

#include <QObject>

#include <wayland-client.h>

#include <QtWaylandClient/private/qwayland-wayland.h>
#include <QtWaylandClient/private/qwayland-fbx-text.h>

QT_BEGIN_NAMESPACE

namespace QtWaylandClient {

class QWaylandDisplay;

class QWaylandFbxText : public QObject, public QtWayland::fbx_text
{
    Q_OBJECT

public:
    QWaylandFbxText(struct ::wl_registry *registry, uint32_t id, int version);
    virtual ~QWaylandFbxText();

    void fbx_text_unicode(uint32_t time, int32_t character) override;

signals:
    void unicodeCharacter(uint32_t time, uint32_t character);
};

}

QT_END_NAMESPACE

#endif
