// -*- c++ -*-
#ifndef QFBXWAYLANDEGLPLATFORMINTEGRATION_H
#define QFBXWAYLANDEGLPLATFORMINTEGRATION_H

#include <QtWaylandClient/private/qwaylandintegration_p.h>
#include <QFbxAppClient.hh>

#include "../qwayland-egl/qwaylandeglplatformintegration.h"
#include "qfbxservices.h"

QT_BEGIN_NAMESPACE

namespace QtWaylandClient {

class QWaylandFbxEglPlatformIntegration
    : public QWaylandEglPlatformIntegration
{
public:
    QWaylandFbxEglPlatformIntegration()
        : QWaylandEglPlatformIntegration()
        , m_services(new QFbxServices(QFbxAppClient::instance()))
    {
    }

    virtual ~QWaylandFbxEglPlatformIntegration() { }

    QPlatformServices *services() const override
    {
        return m_services;
    }

private:
    QFbxServices *m_services;
};

}

QT_END_NAMESPACE

#endif
