/****************************************************************************
**
** Copyright (C) 2013 Klarälvdalens Datakonsult AB (KDAB).
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Compositor.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QWAYLANDINPUTCONTEXT_H
#define QWAYLANDINPUTCONTEXT_H

#include <QtGui/qevent.h>

#include <qpa/qplatforminputcontext.h>

#include <QtWaylandClient/private/qwayland-text.h>

QT_BEGIN_NAMESPACE

namespace QtWaylandClient {

class QWaylandDisplay;

class QWaylandTextInput : public QObject, public QtWayland::wl_text_input
{
    Q_OBJECT

public:
    QWaylandTextInput(struct ::wl_text_input *text_input);

    QString commitString() const;

    void reset();
    void updateState(Qt::InputMethodQueries queries = Qt::ImQueryAll);
    bool enabled() const;

protected:
    void text_input_preedit_cursor(int32_t index) Q_DECL_OVERRIDE;
    void text_input_preedit_styling(uint32_t index, uint32_t length, uint32_t style) Q_DECL_OVERRIDE;
    void text_input_preedit_string(uint32_t serial, const QString &text, const QString &commit) Q_DECL_OVERRIDE;
    void text_input_commit_string(uint32_t serial, const QString &text) Q_DECL_OVERRIDE;
    void text_input_enter(wl_surface *surface) Q_DECL_OVERRIDE;
    void text_input_leave() Q_DECL_OVERRIDE;
    void text_input_delete_surrounding_text(int32_t index, uint32_t length) Q_DECL_OVERRIDE;
    void text_input_keysym(uint32_t serial, uint32_t time, uint32_t sym, uint32_t state, uint32_t modifiers);
    void text_input_modifiers_map(wl_array *map) Q_DECL_OVERRIDE;
    void text_input_input_panel_state(uint32_t state) Q_DECL_OVERRIDE;

private:
    bool query(Qt::InputMethodQueries queries);

    QString m_commit;
    int m_commitIndex;
    int m_commitLength;
    QList<QInputMethodEvent::Attribute> m_preeditAttributes;
    uint32_t m_serial;
    uint32_t m_resetSerial;
    bool m_enabled;

    uint32_t m_shiftMask;
    uint32_t m_ctrlMask;
    uint32_t m_altMask;
    uint32_t m_metaMask;

signals:
    void inputPanelVisibilityChanged(bool visible);
    void enabledChanged(bool enabled);
    void done();
};

class QWaylandInputContext : public QPlatformInputContext
{
    Q_OBJECT
public:
    explicit QWaylandInputContext(QWaylandDisplay *display);

    bool isValid() const Q_DECL_OVERRIDE;
    bool hasCapability(Capability capability) const Q_DECL_OVERRIDE;

    void reset() Q_DECL_OVERRIDE;
    void commit() Q_DECL_OVERRIDE;
    void update(Qt::InputMethodQueries) Q_DECL_OVERRIDE;
    void invokeAction(QInputMethod::Action, int cursorPosition) Q_DECL_OVERRIDE;
    bool filterEvent(const QEvent *event) Q_DECL_OVERRIDE;

    void showInputPanel() Q_DECL_OVERRIDE;
    void hideInputPanel() Q_DECL_OVERRIDE;
    bool isInputPanelVisible() const Q_DECL_OVERRIDE;

    void setFocusObject(QObject *object) Q_DECL_OVERRIDE;

private slots:
    void inputPanelVisibilityChanged(bool visible);
    void textInputEnabledChanged(bool enabled);
    void textInputDone();

private:
    void checkActivate();
    void activateTextInput();
    void deactivateTextInput();
    bool ensureTextInput();

    QWaylandDisplay *mDisplay;
    QScopedPointer<QWaylandTextInput> mTextInput;
    bool mShow;
    bool mVisible;
    bool mActivated;
    bool mDone;
};

}

QT_END_NAMESPACE

#endif // QWAYLANDINPUTCONTEXT_H
