#include "qfbxvideowindow.h"
#include "qfbxplayersession.h"

#include <fbxmms.h>

QFbxVideoWindow::QFbxVideoWindow(QFbxPlayerSession *session, QObject *parent)
    : QVideoWindowControl(parent)
    , m_session(session)
    , m_winId(0)
{
    uint64_t id;
    if (!fbxmms_plane_id_get(m_session->bus(), FBXMMS_VIDEO_PLANE_PRIMARY, &id))
        m_winId = id;

    m_source_rect_changed_signal =
        fbxmms_bind_plane_source_rect_changed(m_session->bus(),
                QFbxVideoWindow::cb_source_rect_changed, this);
}

QFbxVideoWindow::~QFbxVideoWindow()
{
    fbxmms_unbind(m_session->bus(), m_source_rect_changed_signal);
}

WId QFbxVideoWindow::winId() const
{
    return m_winId;
}

void QFbxVideoWindow::setWinId(WId id)
{
}

QRect QFbxVideoWindow::displayRect() const
{
    struct fbxmms_rectangle r;

    if (fbxmms_plane_geometry_get(m_session->bus(), FBXMMS_VIDEO_PLANE_PRIMARY, &r))
        return QRect();
    else
        return QRect(r.x, r.y, r.width, r.height);
}

void QFbxVideoWindow::setDisplayRect(const QRect &rect)
{
    struct fbxmms_rectangle r;

    r.x = 0;
    r.y = 0;
    r.width = rect.width();
    r.height = rect.height();

    fbxmms_plane_geometry_set(m_session->bus(),
            FBXMMS_VIDEO_PLANE_PRIMARY, &r);
}

Qt::AspectRatioMode QFbxVideoWindow::aspectRatioMode() const
{
    enum fbxmms_scaling_mode scaling_mode;

    if (fbxmms_plane_scaling_mode_get(m_session->bus(),
                FBXMMS_VIDEO_PLANE_PRIMARY, &scaling_mode))
        scaling_mode = FBXMMS_SCALING_MODE_LETTERBOX;

    switch (scaling_mode) {
    case FBXMMS_SCALING_MODE_NONE:
    case FBXMMS_SCALING_MODE_LETTERBOX:
        break;
    case FBXMMS_SCALING_MODE_PANSCAN:
        return Qt::KeepAspectRatioByExpanding;
    case FBXMMS_SCALING_MODE_FULLSCREEN:
    case FBXMMS_SCALING_MODE_ANAMORPHIC:
        return Qt::IgnoreAspectRatio;
    }

    return Qt::KeepAspectRatio;
}

void QFbxVideoWindow::setAspectRatioMode(Qt::AspectRatioMode mode)
{
    enum fbxmms_scaling_mode scaling_mode;

    switch (mode) {
    default:
    case Qt::KeepAspectRatio:
        scaling_mode = FBXMMS_SCALING_MODE_LETTERBOX;
        break;
    case Qt::KeepAspectRatioByExpanding:
        scaling_mode = FBXMMS_SCALING_MODE_PANSCAN;
        break;
    case Qt::IgnoreAspectRatio:
        scaling_mode = FBXMMS_SCALING_MODE_FULLSCREEN;
        break;
    }

    fbxmms_plane_scaling_mode_set(m_session->bus(), FBXMMS_VIDEO_PLANE_PRIMARY,
                                  scaling_mode);
}

void QFbxVideoWindow::repaint()
{
}

int QFbxVideoWindow::brightness() const
{
    return 0;
}

void QFbxVideoWindow::setBrightness(int brightness)
{
}

int QFbxVideoWindow::contrast() const
{
    return 0;
}

void QFbxVideoWindow::setContrast(int contrast)
{
}

int QFbxVideoWindow::hue() const
{
    return 0;
}

void QFbxVideoWindow::setHue(int hue)
{
}

int QFbxVideoWindow::saturation() const
{
    return 0;
}

void QFbxVideoWindow::setSaturation(int saturation)
{
}

bool QFbxVideoWindow::isFullScreen() const
{
    return false;
}

void QFbxVideoWindow::setFullScreen(bool fullScreen)
{
}

QSize QFbxVideoWindow::nativeSize() const
{
    struct fbxmms_rectangle rect;

    if (!fbxmms_plane_source_rect_get(m_session->bus(),
                FBXMMS_VIDEO_PLANE_PRIMARY,
                &rect) && rect.width > 0 && rect.height > 0)
        return QSize(rect.width, rect.height);

    return QSize();
}

void QFbxVideoWindow::cb_source_rect_changed(void *priv,
    enum fbxmms_video_plane plane)
{
    QFbxVideoWindow *win = static_cast<QFbxVideoWindow *>(priv);

    if (plane == FBXMMS_VIDEO_PLANE_PRIMARY)
        emit win->nativeSizeChanged();
}
