#ifndef QFBXPLAYERSESSION_H
#define QFBXPLAYERSESSION_H

#include <QtCore/qobject.h>
#include <QtMultimedia/qaudio.h>

#include <libqfbxbus.h>

QT_BEGIN_NAMESPACE

class QFbxPlayerSession : public QObject
{
    Q_OBJECT

public:
    QFbxPlayerSession(QObject *parent);
    virtual ~QFbxPlayerSession();

    int id() { return 0; };
    QFbxbusInstance &bus() { return m_bus; };

    QAudio::Role audioRole() const;
    void setAudioRole(QAudio::Role role);

    QList<QAudio::Role> supportedAudioRoles() const;

private:
    QFbxbusInstance m_bus;
    QAudio::Role m_audioRole;
};

QT_END_NAMESPACE

#endif // QFBXPLAYERSESSION_H
