#include "qfbxaudiorolecontrol.h"
#include "qfbxplayersession.h"

QT_BEGIN_NAMESPACE

QFbxAudioRoleControl::QFbxAudioRoleControl(QFbxPlayerSession *session, QObject *parent)
    : QAudioRoleControl(parent)
    , m_session(session)
{
}

QFbxAudioRoleControl::~QFbxAudioRoleControl()
{
}

QAudio::Role QFbxAudioRoleControl::audioRole() const
{
    return m_session->audioRole();
}

void QFbxAudioRoleControl::setAudioRole(QAudio::Role role)
{
    m_session->setAudioRole(role);
    emit audioRoleChanged(role);
}

QList<QAudio::Role> QFbxAudioRoleControl::supportedAudioRoles() const
{
    return m_session->supportedAudioRoles();
}
