#ifndef QFBXDECLARATIVEVIDEOOUTPUT_H
#define QFBXDECLARATIVEVIDEOOUTPUT_H

#include "qdeclarativevideooutput_backend_p.h"

#include <QtWaylandClient/private/qwayland-wayland.h>

QT_BEGIN_NAMESPACE

namespace fbx {
class ForeignSurfaceManager;
};

class QVideoWindowControl;
class QFbxHoleNode;

class QFbxDeclarativeVideoOutput
    : public QObject
    , public QDeclarativeVideoBackend
    , QtWayland::wl_subsurface
{
    Q_OBJECT

public:
    QFbxDeclarativeVideoOutput(QDeclarativeVideoOutput *parent);
    ~QFbxDeclarativeVideoOutput();

    bool init(QMediaService *service);
    void itemChange(QQuickItem::ItemChange change, const QQuickItem::ItemChangeData &changeData);
    void releaseSource();
    void releaseControl();
    QSize nativeSize() const;
    void updateGeometry();
    QSGNode *updatePaintNode(QSGNode *oldNode, QQuickItem::UpdatePaintNodeData *data);
    QAbstractVideoSurface *videoSurface() const;
    QRectF adjustedViewport() const Q_DECL_OVERRIDE;

private slots:
    void bindWindow();
    void syncItem();
    void syncNode();
    void frameSwapped();

private:
    void unbindWindow();
    void rebindWindow();

    bool bindWaylandSurface();
    void unbindWaylandSurface();

    QRectF absoluteRect(const QRectF &geometry) const;
    void beginGeometryChange();
    void endGeometryChange();

    QPointer<QVideoWindowControl> m_videoWindowControl;
    fbx::ForeignSurfaceManager *m_manager;
    QPoint m_absolutePos;
    QSize m_size;
    QQuickWindow *m_window;
    QFbxHoleNode *m_node;
    bool m_resizing : 1;
    bool m_dirtySize : 1;
    bool m_dirtyPosition : 1;
};

QT_END_NAMESPACE

#endif
