#ifndef QFBXPLAYERCONTROL_H
#define QFBXPLAYERCONTROL_H

#include <QtCore/qobject.h>
#include <QtCore/qstack.h>

#include <libqfbxbus.h>
#include <fbxmms-types.h>

#include <qmediaplayercontrol.h>
#include <qmediaplayer.h>

QT_BEGIN_NAMESPACE

class QMediaPlayerResourceSetInterface;

class QMediaPlaylist;
class QMediaPlaylistNavigator;
class QSocketNotifier;

class QFbxPlayerSession;
class QFbxPlayerService;

class QFbxPlayerControl : public QMediaPlayerControl
{
    Q_OBJECT

public:
    QFbxPlayerControl(QFbxPlayerSession *session, QObject *parent = 0);
    ~QFbxPlayerControl();

    QMediaPlayer::State state() const;
    QMediaPlayer::MediaStatus mediaStatus() const;

    qint64 position() const;
    qint64 duration() const;

    int bufferStatus() const;

    int volume() const;
    bool isMuted() const;

    bool isAudioAvailable() const;
    bool isVideoAvailable() const;
    void setVideoOutput(QObject *output);

    bool isSeekable() const;
    QMediaTimeRange availablePlaybackRanges() const;

    qreal playbackRate() const;
    void setPlaybackRate(qreal rate);

    QMediaContent media() const;
    const QIODevice *mediaStream() const;
    void setMedia(const QMediaContent&, QIODevice *);

public Q_SLOTS:
    void setPosition(qint64 pos);

    void play();
    void pause();
    void stop();

    void setVolume(int volume);
    void setMuted(bool muted);

private:
    void setState(QMediaPlayer::State state);
    void setMediaStatus(QMediaPlayer::MediaStatus status);
    void setBuffering(int buffering);
    void setDuration(qint64 duration);

    void preempt();
    void activate();
    void deactivate();

    QFbxPlayerSession *m_session;
    QMediaPlayer::State m_state;
    QMediaPlayer::MediaStatus m_mediaStatus;
    int m_buffering;
    qint64 m_duration;
    int m_volume;
    bool m_mute;

    static void cb_error(void *priv, int media,
                         const struct fbxmms_media_error *error);

    static void cb_media_state_changed(void *priv, int media,
                                       enum fbxmms_media_state state);

    static void cb_buffering_changed(void *priv, int media, int buffering);

    static void cb_duration_changed(void *priv, int media, int32_t duration);

    static void cb_playback_state_changed(void *priv, int media,
                                          enum fbxmms_playback_state prev,
                                          enum fbxmms_playback_state state,
                                          enum fbxmms_playback_state pending);
};

QT_END_NAMESPACE

#endif
