#ifndef QSGHOLENODE_H
#define QSGHOLENODE_H

#include <QtQuick/qsgnode.h>
#include <QtQuick/qsgmaterial.h>

QT_BEGIN_NAMESPACE

class QSGHoleMaterial : public QSGMaterial
{
public:
    QSGHoleMaterial();
    QSGMaterialType *type() const Q_DECL_OVERRIDE;
    QSGMaterialShader *createShader() const Q_DECL_OVERRIDE;
};

class QSGHoleNode : public QSGGeometryNode
{
public:
    QSGHoleNode(const QRectF &rect);
    QSGHoleNode();

    void setRect(const QRectF &rect);
    inline void setRect(qreal x, qreal y, qreal w, qreal h) { setRect(QRectF(x, y, w, h)); }
    QRectF rect() const;

private:
    QSGHoleMaterial m_material;
    QSGGeometry m_geometry;
};

QT_END_NAMESPACE

#endif // QSGHOLENODE_H
