#ifndef FOREIGN_SURFACE_MANAGER_H_
# define FOREIGN_SURFACE_MANAGER_H_

#include "qwayland-freebox.h"
#include "QtWaylandClient/private/qwayland-wayland.h"
#include <QtCore/QObject>

namespace fbx {

class ForeignSurfaceManager
    : public QObject,
    public QtWayland::fbx_foreign_surface_manager,
    public QtWayland::wl_subcompositor,
    QtWayland::wl_registry
{
    Q_OBJECT;
public:
    static ForeignSurfaceManager *getInstance();
    bool isConnected() const;

signals:
    void connected();

protected:
    void registry_global(uint32_t name, const QString &interface, uint32_t version) override;

private:
    ~ForeignSurfaceManager();
    ForeignSurfaceManager(QObject *parent = 0);

    static ForeignSurfaceManager *s_instance;
    bool m_ready;
};

}

#endif /* !FOREIGN_SURFACE_MANAGER_H_ */
