#include "qfbxplayersession.h"

QT_BEGIN_NAMESPACE

QFbxPlayerSession::QFbxPlayerSession(QObject *parent)
    : QObject(parent)
    , m_audioRole(QAudio::UnknownRole)
{
}

QFbxPlayerSession::~QFbxPlayerSession()
{
}

QAudio::Role QFbxPlayerSession::audioRole() const
{
    return m_audioRole;
}

void QFbxPlayerSession::setAudioRole(QAudio::Role role)
{
    m_audioRole = role;
}

QList<QAudio::Role> QFbxPlayerSession::supportedAudioRoles() const
{
    return {
        QAudio::UnknownRole,
        QAudio::MusicRole,
        QAudio::VideoRole,
        QAudio::NotificationRole,
        QAudio::AccessibilityRole,
        QAudio::SonificationRole,
        QAudio::GameRole,
    };
}

QT_END_NAMESPACE
