#ifndef QFBXMETADATAPROVIDER_H
#define QFBXMETADATAPROVIDER_H

#include <qmetadatareadercontrol.h>

QT_BEGIN_NAMESPACE

class QFbxPlayerSession;

class QFbxMetaDataProvider : public QMetaDataReaderControl
{
    Q_OBJECT

    enum UpdateFlag {
        UpdateVideoTags = 1 << 0,
        UpdateAudioTags = 1 << 1,
        UpdateMetadata  = 1 << 2,
    };

    Q_DECLARE_FLAGS (UpdateFlags, UpdateFlag)

public:
    QFbxMetaDataProvider(QFbxPlayerSession *session, QObject *parent);
    virtual ~QFbxMetaDataProvider();

    QStringList availableMetaData() const;
    bool isMetaDataAvailable() const;
    QVariant metaData(const QString &key) const;

private:
    void updateMetadata(UpdateFlags flags);

    QFbxPlayerSession *m_session;
    QVariantMap m_tags;

    static void cb_video_tracks_changed(void *priv, int media);
    static void cb_audio_tracks_changed(void *priv, int media);
    static void cb_metadata_changed(void *priv, int media);

    static QStringList audioKeys;
    static QStringList videoKeys;
    static QStringList metadataKeys;
};

QT_END_NAMESPACE

#endif // QFBXMETADATAPROVIDER_H
