#include "foreign_surface_manager.h"
#include "wayland-client.h"
#include <QtGui/QGuiApplication>
#include <QtGui/qpa/qplatformnativeinterface.h>

namespace fbx {

ForeignSurfaceManager::ForeignSurfaceManager(QObject *parent)
    : QObject(parent)
    , m_ready(false)
{
    QPlatformNativeInterface *native = QGuiApplication::platformNativeInterface();

    struct ::wl_display *display = (struct ::wl_display *)
        native->nativeResourceForIntegration("wl_display");

    if (!display)
        return;

    QtWayland::wl_registry::init(wl_display_get_registry(display));
}

ForeignSurfaceManager::~ForeignSurfaceManager()
{
}

void ForeignSurfaceManager::registry_global(uint32_t id, const QString &interface, uint32_t version)
{
    if (interface == QStringLiteral("fbx_foreign_surface_manager"))
        QtWayland::fbx_foreign_surface_manager::init(QtWayland::wl_registry::object(), id, 1);
    else if (interface == QStringLiteral("wl_subcompositor"))
        QtWayland::wl_subcompositor::init(QtWayland::wl_registry::object(), id, 1);

    if (!m_ready && isConnected()) {
        m_ready = true;
        emit connected();
    }
}

ForeignSurfaceManager *ForeignSurfaceManager::s_instance = NULL;

ForeignSurfaceManager *ForeignSurfaceManager::getInstance()
{
    if (!s_instance)
        s_instance = new ForeignSurfaceManager();

    return s_instance;
}

bool ForeignSurfaceManager::isConnected() const
{
    return QtWayland::fbx_foreign_surface_manager::isInitialized() &&
        QtWayland::wl_subcompositor::isInitialized();
}

}
