#ifndef QFBXVIDEOWINDOW_H
#define QFBXVIDEOWINDOW_H

#include <qvideowindowcontrol.h>

QT_BEGIN_NAMESPACE

class QFbxPlayerSession;

class QFbxVideoWindow : public QVideoWindowControl
{
    Q_OBJECT

public:
    QFbxVideoWindow(QFbxPlayerSession *session, QObject *parent = 0);
    ~QFbxVideoWindow();

    WId winId() const;
    void setWinId(WId id);

    QRect displayRect() const;
    void setDisplayRect(const QRect &rect);

    bool isFullScreen() const;
    void setFullScreen(bool fullScreen);

    QSize nativeSize() const;

    Qt::AspectRatioMode aspectRatioMode() const;
    void setAspectRatioMode(Qt::AspectRatioMode mode);

    void repaint();

    int brightness() const;
    void setBrightness(int brightness);

    int contrast() const;
    void setContrast(int contrast);

    int hue() const;
    void setHue(int hue);

    int saturation() const;
    void setSaturation(int saturation);

private:
    QFbxPlayerSession *m_session;
    WId m_winId;
};

QT_END_NAMESPACE

#endif
