#include "qfbxplayerserviceplugin.h"
#include "qfbxplayerservice.h"

QMediaService* QFbxPlayerServicePlugin::create(const QString &key)
{
    if (key == QLatin1String(Q_MEDIASERVICE_MEDIAPLAYER))
        return new QFbxPlayerService;

    qWarning() << "Freebox service plugin: unsupported key:" << key;
    return 0;
}

void QFbxPlayerServicePlugin::release(QMediaService *service)
{
    delete service;
}

QMediaServiceProviderHint::Features QFbxPlayerServicePlugin::supportedFeatures(
        const QByteArray &service) const
{
    if (service == Q_MEDIASERVICE_MEDIAPLAYER)
        return 0;
    else
        return QMediaServiceProviderHint::Features();
}
