#include <QtCore/qvariant.h>

#include "qfbxplayerservice.h"
#include "qfbxplayersession.h"
#include "qfbxplayercontrol.h"
#include "qfbxmetadataprovider.h"
#include "qfbxvideowindow.h"

#include <private/qmediaplaylistnavigator_p.h>
#include <qvideowindowcontrol.h>
#include <qmediaplaylist.h>

QT_BEGIN_NAMESPACE

QFbxPlayerService::QFbxPlayerService(QObject *parent)
    : QMediaService(parent)
{
    m_session = new QFbxPlayerSession(this);
    m_control = new QFbxPlayerControl(m_session, this);
    m_metaData = new QFbxMetaDataProvider(m_session, this);
    m_videoOutput = new QFbxVideoWindow(m_session, this);
}

QFbxPlayerService::~QFbxPlayerService()
{
    delete m_videoOutput;
    delete m_metaData;
    delete m_control;
}

QMediaControl *QFbxPlayerService::requestControl(const char *name)
{
    if (qstrcmp(name, QMediaPlayerControl_iid) == 0)
        return m_control;

    if (qstrcmp(name, QMetaDataReaderControl_iid) == 0)
        return m_metaData;

    if (qstrcmp(name, QVideoWindowControl_iid) == 0) {
        m_control->setVideoOutput(m_videoOutput);
        return m_videoOutput;
    }

    return 0;
}

void QFbxPlayerService::releaseControl(QMediaControl *control)
{
    if (control == m_videoOutput)
        m_control->setVideoOutput(0);
}

QT_END_NAMESPACE
