#ifndef QFBXPLAYERSERVICE_H
#define QFBXPLAYERSERVICE_H

#include <QtCore/qobject.h>
#include <QtCore/qiodevice.h>

#include <qmediaservice.h>

QT_BEGIN_NAMESPACE
class QMediaPlayerControl;
class QMediaPlaylist;
class QMediaPlaylistNavigator;

class QFbxMetaData;
class QFbxPlayerSession;
class QFbxPlayerControl;
class QFbxMetaDataProvider;

class QFbxPlayerService : public QMediaService
{
    Q_OBJECT
public:
    QFbxPlayerService(QObject *parent = 0);
    ~QFbxPlayerService();

    QMediaControl *requestControl(const char *name);
    void releaseControl(QMediaControl *control);

private:
    QFbxPlayerSession *m_session;
    QFbxPlayerControl *m_control;
    QFbxMetaDataProvider *m_metaData;
    QMediaControl *m_videoOutput;
};

QT_END_NAMESPACE

#endif
