#ifndef QFBXPLAYERCONTROL_H
#define QFBXPLAYERCONTROL_H

#include <QtCore/qobject.h>
#include <QtCore/qstack.h>

#include <libqfbxbus.h>
#include <fbxmms-types.h>

#include <qmediaplayercontrol.h>
#include <qmediaplayer.h>

QT_BEGIN_NAMESPACE

class QMediaPlayerResourceSetInterface;

class QMediaPlaylist;
class QMediaPlaylistNavigator;
class QSocketNotifier;

class QFbxPlayerSession;
class QFbxPlayerService;

class QFbxPlayerControl : public QMediaPlayerControl
{
    Q_OBJECT

public:
    QFbxPlayerControl(QFbxPlayerSession *session, QObject *parent = 0);
    ~QFbxPlayerControl();

    QMediaPlayer::State state() const;
    QMediaPlayer::MediaStatus mediaStatus() const;

    qint64 position() const;
    qint64 duration() const;

    int bufferStatus() const;

    int volume() const;
    bool isMuted() const;

    bool isAudioAvailable() const;
    bool isVideoAvailable() const;
    void setVideoOutput(QObject *output);

    bool isSeekable() const;
    QMediaTimeRange availablePlaybackRanges() const;

    qreal playbackRate() const;
    void setPlaybackRate(qreal rate);

    QMediaContent media() const;
    const QIODevice *mediaStream() const;
    void setMedia(const QMediaContent&, QIODevice *);

public Q_SLOTS:
    void setPosition(qint64 pos);

    void play();
    void pause();
    void stop();

    void setVolume(int volume);
    void setMuted(bool muted);

private:
    QFbxPlayerSession *m_session;
    int m_volume;
    bool m_mute;

    static void cb_media_state_changed(void *priv, int media,
                                       enum fbxmms_media_state state);

    static void cb_playback_state_changed(void *priv, int media,
                                          enum fbxmms_playback_state prev,
                                          enum fbxmms_playback_state state,
                                          enum fbxmms_playback_state pending);
};

QT_END_NAMESPACE

#endif
