#ifndef QFBXDECLARATIVEVIDEOOUTPUT_H
#define QFBXDECLARATIVEVIDEOOUTPUT_H

#include "qdeclarativevideooutput_backend_p.h"

#include <QtWaylandClient/private/qwayland-wayland.h>

QT_BEGIN_NAMESPACE

namespace fbx {
class ForeignSurfaceManager;
};

class QVideoWindowControl;

class QFbxDeclarativeVideoOutput
    : public QObject
    , public QDeclarativeVideoBackend
    , QtWayland::wl_subsurface
{
    Q_OBJECT

public:
    QFbxDeclarativeVideoOutput(QDeclarativeVideoOutput *parent);
    ~QFbxDeclarativeVideoOutput();

    bool init(QMediaService *service);
    void itemChange(QQuickItem::ItemChange change, const QQuickItem::ItemChangeData &changeData);
    void releaseSource();
    void releaseControl();
    QSize nativeSize() const;
    void updateGeometry();
    QSGNode *updatePaintNode(QSGNode *oldNode, QQuickItem::UpdatePaintNodeData *data);
    QAbstractVideoSurface *videoSurface() const;
    QRectF adjustedViewport() const Q_DECL_OVERRIDE;

private slots:
    void bind();
    void sync();
    void frameSwapped();

private:
    void unbind();
    void rebind();

    QRectF absoluteGeometry() const;
    void beginGeometryChange();
    void endGeometryChange();

    QPointer<QVideoWindowControl> m_videoWindowControl;
    fbx::ForeignSurfaceManager *m_manager;
    QPoint m_absolutePos;
    QSize m_size;
    QQuickWindow *m_window;
    bool m_resizing;
};

QT_END_NAMESPACE

#endif
