#ifndef __GST_SUBSAMPLE_PATCHER__
#define __GST_SUBSAMPLE_PATCHER__

#include <gst/gst.h>

#define GST_MAX_SUBSAMPLE_PER_AU 20

typedef struct
{
  gsize clear_bytes;
  gsize protected_bytes;
} GstSubsample;

typedef struct
{
  guint subsample_count;
  GstSubsample subsamples[GST_MAX_SUBSAMPLE_PER_AU];
} GstSubsampleMap;

typedef struct
{
  GstSubsampleMap src;
  GstSubsampleMap dst;
  gsize pos;
  gboolean init;
  gboolean error;
} GstSubsamplePatcher;

gboolean gst_subsample_patcher_init (GstSubsamplePatcher * patcher,
    GstBuffer * buffer);

gboolean gst_subsample_patcher_skip (GstSubsamplePatcher * patcher,
    gsize count);

gboolean gst_subsample_patcher_insert (GstSubsamplePatcher * patcher,
    gsize count);

gboolean gst_subsample_patcher_insert_at (GstSubsamplePatcher * patcher,
    gsize offset, gsize count);

gboolean gst_subsample_patcher_copy (GstSubsamplePatcher * patcher,
    gsize count);

gboolean gst_subsample_patcher_commit (GstSubsamplePatcher * patcher,
    GstBuffer * buffer);

#endif /* __GST_SUBSAMPLE_PATCHER__ */
