# ltmain.sh replacement

set -e

shared_ext='.so'

# echo "[36mfbxlibtool $*[0m"

read_var()
{
    local file="$1"
    local var_name="$2"
    local IFS="="

    while read key val
    do
        if [ "$key" = "$var_name" ]
        then
            eval "VAL=$val"
            break
        fi
    done < "$file"
}

is_convenience()
{
    read_var "$1" "libdir"

    if [ -z "$VAL" ]
    then
        return 0
    else
        return 1
    fi
}

resolve_shared_deps()
{
    local dep

    for dep in $@
    do
        case $dep in
            *.la)
                read_var "$dep" "installed"
                if [ "$VAL" = "yes" ]
                then
                    continue
                fi

                local libname="${dep%.la}"
                local libdir="${libname%/*}/.libs"
                libname="${libname##*/}"

                if [ -r "$libdir/$libname.so" ]
                then
                    local xrpath="-Wl,-rpath-link,$libdir"
                    case " $ldflags " in
                        *" $xrpath "*)
                            ;;
                        *)
                            ldflags="$ldflags $xrpath"
                            ;;
                    esac
                    read_var "$dep" "dependency_libs"
                    resolve_shared_deps "$VAL"
                fi
                ;;
            -l*)
                deps_static="$deps_static $dep"
                ;;
        esac
    done
}

resolve_static_deps()
{
    local dep

    for dep in $@
    do
        case $dep in
            *.la)
                read_var "$dep" "dependency_libs"
                resolve_static_deps "$VAL"
                ;;
            -l*)
                deps_static="$deps_static $dep"
                ldlibs="$ldlibs $dep"
                ldlibs_pic="$ldlibs_pic $dep"
                ;;
        esac
    done
}

run()
{
    local cmd="$1"
    if [ "$silent" != yes ]
    then
        eval "echo fbxlibtool: $mode: $cmd"
    fi
    eval "$cmd"
}

write_la()
{
    local path="$1"
    local basename="${path##*/}"
    cat > "$path" <<EOF
# $basename - a libtool library file
# Generated by fbxlibtool

library_names='$library_names'
pic_archives='$pic_archives'
old_library='$old_library'
dependency_libs='$dependency_libs'
current=$current
age=$age
revision=$revision
installed=$installed
shouldnotlink=$shouldnotlink
libdir='$libdir'
EOF
}

while [ "$#" -gt 0 ]
do
    arg=$1
    shift

    case $arg in
        --tag=*)
            tag=${arg#--tag=}
            ;;
        --tag)
            tag="$1"
            shift
            ;;
        --mode=*)
            mode=${arg#--mode=}
            ;;
        --config)
            re_begincf='^# ### BEGIN LIBTOOL'
            re_endcf='^# ### END LIBTOOL'
            exec sed "1,/$re_begincf CONFIG/d;/$re_endcf CONFIG/,\$d" < "$0"
            ;;
        --version)
            echo "fbxlibtool 2.4"
            exit 0
            ;;
        --help-all)
            cat <<EOF
Usage: fbxlibtool [OPTION]... [MODE-ARG]...
  or:  fbxlibtool [OPTION]... --mode=compile COMPILE-COMMAND... SOURCEFILE
  or:  fbxlibtool [OPTION]... --mode=link LINK-COMMAND...
  or:  fbxlibtool [OPTION]... --mode=execute COMMAND [ARGS]...
  or:  fbxlibtool [OPTION]... --mode=install INSTALL-COMMAND...
  or:  fbxlibtool [OPTION]... --mode=finish [LIBDIR]...
  or:  fbxlibtool [OPTION]... --mode=uninstall RM [RM-OPTION]... FILE...
  or:  fbxlibtool [OPTION]... --mode=clean RM [RM-OPTION]... FILE...
EOF
            exit 0
            ;;
        --silent|--quiet)
            silent="yes"
            ;;
        -avoid-version)
            avoid_version="yes"
            ;;
        -version-info)
            version="$1"
            version_number="no"
            shift
            ;;
        -version-number)
            version="$1"
            version_number="yes"
            shift
            ;;
        -release)
            release="-$1"
            shift
            ;;
        -export-symbols)
            export_sym="$1"
            shift
            ;;
        -export-symbols-regex)
            export_sym_regex="$1"
            shift
            ;;
        -export-dynamic)
            ldflags="$ldflags -rdynamic"
            ;;
        -no-install)
            ;;
        -no-undefined)
            ldflags="$ldflags -Wl,-no-undefined"
            ;;
        -module)
            module="yes"
            ;;
        -rpath)
            rpath="$1"
            shift
            ;;
        -shrext)
            shared_ext="$1"
            shift
            ;;
        -static)
            build_libtool_libs="no"
            build_old_libs="yes"
            ;;
        -dlpreopen)
            ;;
        -o)
            case $mode in
                compile|link)
                    out="$1"
                    dir=
                    if [ "${out%/*}" != "$out" ]
                    then
                        dir="${out%/*}/"
                    fi
                    lout="$dir.libs/${out##*/}"
                    shift
                    ;;
                *)
                    cmd="$cmd '$arg'"
                    cmd_pic="$cmd_pic '$arg'"
                    ;;
            esac
            ;;
        *.lo)
            dir=
            if [ "${arg%/*}" != "$arg" ]
            then
                dir="${arg%/*}/"
            fi
            larg="$dir.libs/${arg##*/}"
            objs="$objs '$arg'"
            objs_pic="$objs_pic '$larg'"
            cmd="$cmd '$arg'"
            cmd_pic="$cmd_pic '$larg'"
            ;;
        *.la)
            arg="${arg%.la}"
            dir="${arg%/*}/"
            if [ "$dir" = "$arg/" ]
            then
                dir=
            fi
            case $mode in
                link)
                    deps="$(readlink -f $arg.la) $deps"
                    read_var "$arg.la" "dependency_libs"
                    dep="$VAL"
                    read_var "$arg.la" "installed"
                    installed="$VAL"
                    if [ "$installed" = "yes" ]
                    then
                        lib="$dir/${arg##*/}"
                    else
                        lib="$dir.libs/${arg##*/}"
                    fi
                    if [ -r "$lib.so" ]
                    then
                        resolve_shared_deps $dep
                        cmd="$cmd '$lib.so'"
                        cmd_pic="$cmd_pic '$lib.so'"
                    else
                        case $out in
                            *.la)
                                if is_convenience "$arg.la"
                                then
                                    if [ -r "${lib}_pic.a" ]
                                    then
                                        for file in $($AR t "${lib}_pic.a")
                                        do
                                            objs_pic="$objs_pic '$file'"
                                        done
                                    fi
                                    if [ -r "$lib.a" ]
                                    then
                                        for file in $($AR t "$lib.a")
                                        do
                                            objs="$objs '$file'"
                                        done
                                    fi
                                fi
                                pic="_pic"
                                wa_begin="-Wl,-whole-archive"
                                wa_end="-Wl,-no-whole-archive"
                                ;;
                        esac
                        ldlibs_local="$ldlibs_local $wa_begin '$lib.a' $wa_end"
                        ldlibs_local_pic="$ldlibs_local_pic $wa_begin '$lib$pic.a' $wa_end"
                        resolve_static_deps $dep
                    fi
                    ;;
                install)
                    if [ $# -eq 0 ]
                    then
                        cmd="$cmd '$arg.la'"
                        dest="${arg%/*}"
                    else
                        dir="$dir.libs"
                        cmd="$cmd '$dir/${arg##*/}.la'"
                        read_var "$arg.la" "library_names"
                        libs="$VAL"
                        read_var "$arg.la" "old_library"
                        libs="$libs $VAL"
                        read_var "$arg.la" "pic_archives"
                        libs="$libs $VAL"
                        for i in $libs
                        do
                            if [ -r "$dir/$i" ]
                            then
                                inst_list="$inst_list '$dir/$i'"
                            fi
                        done
                    fi
                    ;;
                *)
                    cmd="$cmd '$arg'"
                    cmd_pic="$cmd_pic '$arg'"
                    ;;
            esac
            ;;
        *.c|*.S)
            if [ $mode = compile -a -z "$out" ]
            then
                out="${arg%.*}.lo"
                out=${out##*/}
                lout=".libs/$out"
            fi
            cmd="$cmd '$arg'"
            cmd_pic="$cmd_pic '$arg'"
            ;;
        -l*)
            deps="$deps $arg"
            deps_static="$deps_static $arg"
            ldlibs="$ldlibs '$arg'"
            ldlibs_pic="$ldlibs_pic '$arg'"
            ;;
        *)
            if [ $mode = install -a $# -eq 0 ]
            then
                dest=$arg
            fi
            cmd="$cmd '$arg'"
            cmd_pic="$cmd_pic '$arg'"
            ;;
    esac
done

case $mode in
    compile)
        if [ $build_libtool_libs = yes ]
        then
            mkdir -p "${lout%/*}"
            run "$cmd $pic_flag -o $lout"
        fi
        run "$cmd -o $out"
        ;;
    link)
        case $out in
            *.la)
                out=${out%.la}
                lout=${lout%.la}
                lib=${out##*/}
                destdir="${lout%/*}"
                mkdir -p "$destdir"
                ifs="$IFS"
                IFS=':'
                set -- $version 0 0 0
                IFS="$ifs"
                if [ "$version_number" = yes ]
                then
                    number_major="$1"
                    number_minor="$2"
                    number_revision="$3"
                    current=$(($number_major + $number_minor))
                    age="$number_minor"
                    revision="$number_revision"
                else
                    current="$1"
                    revision="$2"
                    age="$3"
                fi
                major=.$(($current - $age))
                versuffix="$major.$age.$revision"
                if [ "$avoid_version" = "yes" ]
                then
                    versuffix=
                    major=
                fi
                if [ -z "$rpath" ]
                then
                    build_old_libs="yes"
                    thin="T"
                fi
                if [ $build_libtool_libs = yes ]
                then
                    if [ "$module" != yes ]
                    then
                        run "$AR crsD$thin '$destdir/${lib}_pic.a' $objs_pic"
                        pic_archives="${lib}_pic.a"
                        if [ -n "$release" ]
                        then
                            $LN_S -f "${lib}_pic.a" "$destdir/$lib${release}_pic.a"
                            pic_archives="$pic_archives $lib${release}_pic.a"
                        fi
                    fi
                    if [ -n "$rpath" -o "$module" = yes ]
                    then
                        if [ -n "$export_sym_regex" ]
                        then
                            filter="cut -d ' ' -f 2 | sort -u | $EGREP -e '$export_sym_regex'"
                            eval "$NM -AgPp --defined-only $objs_pic | $filter > '$destdir/$lib.sym'"
                            export_sym="$destdir/$lib.sym"
                        fi
                        if [ -n "$export_sym" ]
                        then
                            ver="$destdir/$lib.ver"
                            {
                                echo "{ global:"
                                while read sym
                                do
                                    echo "$sym;"
                                done < "$export_sym"
                                echo "local: *; };"
                            } > "$ver"
                            ldflags="$ldflags -Wl,-version-script,$ver"
                        fi
                        soname="$lib$release$shared_ext$major"
                        shlib="$lib$release$shared_ext$versuffix"
                        deplibs="$ldlibs_local_pic $ldlibs_pic"
                        run "$cmd_pic -o '$destdir/$shlib' -shared -Wl,-soname=$soname $ldflags $deplibs"
                        library_names="$shlib"
                        for linkname in "$lib$release$shared_ext$major" "$lib$shared_ext"
                        do
                            if [ "$shlib" != "$linkname" ]
                            then
                                library_names="$library_names $linkname"
                                $LN_S -f "$shlib" "$destdir/$linkname"
                            fi
                        done
                    fi
                fi
                if [ $build_old_libs = yes -a "$module" != yes ]
                then
                    run "$AR crsD$thin '$lout.a' $objs"
                    old_library="$lib.a"
                fi
                dependency_libs="$deps"
                shouldnotlink="${module:-no}"
                libdir="$rpath"
                installed=no
                write_la "$out.la"
                dependency_libs="$deps_static"
                installed=yes
                write_la "$lout.la"
                ;;
            *)
                mkdir -p "${lout%/*}"
                run "$cmd -o $lout $ldflags $ldlibs_local $ldlibs"
                $LN_S -f "$lout" "$out"
                ;;
        esac
        ;;
    install)
        if [ -n "$inst_list" ]
        then
            run "cp -a $inst_list '$dest'"
        fi
        run "$cmd"
        ;;
    execute)
        run "$cmd"
        ;;
    *)
        echo "fbxlibtool: invalid mode \`$mode'" >&2
        exit 1
        ;;
esac
